#include <math.h>
#include <stdlib.h>
/* ================================================================== */
/* M77_rand - Math77 Pseudo Random Number Generator (Short Algorithm) */
/* ================================================================== */
# undef	BASIC_SEED
#define	BASIC_SEED	161803398
static	long double  CurrentSeed = BASIC_SEED;

void	M77_rand_init(unsigned NewSeed)
{
    CurrentSeed = BASIC_SEED + NewSeed;
}

double (dM77_rand) (void)
{
# undef	MDIV
# undef	AFAC
#define	MDIV	68719476503.0L
#define AFAC	612662.L

    long double Prod;

    Prod = AFAC * CurrentSeed;

    CurrentSeed = fmodl(Prod, MDIV);

    return ((double)(CurrentSeed / MDIV));
}

int (iM77_rand) (void)
{
    return ((unsigned) (dM77_rand() * ((double)RAND_MAX + 1.)) & RAND_MAX);
}
